function AISMN_GoToWorkHotSpot::OnEnter(%this,%obj)
{
   %object = GetThisObject(%obj);
   %object.stopAnimation = true;
   %workplace = GetWorkplace(%obj);
   if (%workplace == 0)
   {
      return;
   }

   %component = slgQueryInterface(%workplace, $CID_BUILDING);
   //If there's no component, report an error. 
   if (%component == 0)
   {
      return;
   }
   
   //Get the index of an available hot spot
   %object = GetThisObject(%obj);
   %hotSpotIndex = %workplace.getObjectHotSpot(%object);
   if (%hotSpotIndex < 0)
   {
      %hotSpotIndex = %workplace.getAvailableHotSpot();
      
      //If the index was invalid, report an error.
      //The previous checks should have prevented this from occuring.
      if (%hotSpotIndex < 0)
      {
         return;
      }
      else
      {
         %workplace.occupyhotspot(%object, %hotSpotIndex);
      }
   }
   
   // if the object is already at the hot spot, do not force animation
   if (IsAtHotspot(%object, %workplace) == true)
   {
      %object.stopAnimation = false;
      return;
   }
   
   %workX = %workplace.getHotSpotX(%hotSpotIndex);
   %workY = %workplace.getHotSpotY(%hotSpotIndex);   
   
   //Set a path the the building's hot spot
   SetPathToSpot(%obj, %workX, %workY);
   %object.playThread(0, "run");
}

function AISMN_GoToWorkHotSpot::OnExit(%this,%obj)
{
   %object = GetThisObject(%obj);
   if (%object.stopAnimation == true)
   {
      %object.playThread(0, "root");
   }
   
   if (%obj.endingCurrentState())
   {
      %workplace = GetWorkplace(%obj);
      if (0 != %workplace)
      {
         %workplace.unoccupyhotspot(%object);
      }
   }
}

//EXIT 0: ERROR
//EXIT 1: NO HOT SPOTS AVAILABLE
//EXIT 2: ARRIVED AT HOT SPOT
//EXIT 3: WORKPLACE DOES NOT EXIST (could have been destroyed)
function AISMN_GoToWorkHotSpot::Update(%this,%obj)
{
   //If the work place does not exist, return out.
   %workplace = GetWorkplace(%obj);
   if( %workplace == 0)
   {
      ReturnValue(%obj, 0);
      return;
   }
   
   //If the character stopped moving, return success
   if (IsFollowingPath(%obj) == false)
   {
      %object = GetThisObject(%obj);
      if (IsAtHotspot(%object, %workplace) == false)
      {
         ReturnValue(%obj, 0);
         return;
      }
      
      %hotSpotIndex = %workplace.getObjectHotSpot(%object);
      %angle = %workplace.getHotSpotAngle(%hotSpotIndex);
      %object.setRotationZ(%angle);
      ReturnValue(%obj, 2);
      return;
   }
   
   //Looks like we should stay in this state for a little longer.
   ReturnValue(%obj, -1);
}

function IsAtHotspot(%object, %workplace)
{
   %hotSpotIndex = %workplace.getObjectHotSpot(%object);
   if (%hotSpotIndex < 0)
   {
      return false;
   }
   
   %workX = %workplace.getHotSpotX(%hotSpotIndex);
   %workY = %workplace.getHotSpotY(%hotSpotIndex);
   %objX = getWord(%object.position, 0);
   %objY = getWord(%object.position, 1);

   %diffX = (%workX - %objX) + 0.5;
   %diffY = (%workY - %objY) + 0.5;
   return (%diffX <= 1 && %diffX >= 0 && %diffY <= 1 && %diffY >= 0);
}
